#include <stdint.h>
#include "bpreplay8.h"
#include <font.h>

#define BPREPLAY8_SPACE          3
#define BPREPLAY8_FIRST_CHAR     33
#define BPREPLAY8_CHARS          94
#define BPREPLAY8_HEIGHT         12
#define BPREPLAY8_WORDS_PER_LINE 2
#define BPREPLAY8_BITS_PER_PIXEL 2

uint16_t bpreplay8_data[BPREPLAY8_CHARS][BPREPLAY8_WORDS_PER_LINE * BPREPLAY8_HEIGHT + 1] =
{
    {  3, 0x8000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0x4000, 0x0000,  0xC000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x5400, 0x0000,  0xF400, 0x0000,  0xF400, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0440, 0x0000,  0x0CC0, 0x0000,  0x1CC0, 0x0000,  0xBFF0, 0x0000,  0x35C0, 0x0000,  0x7BC0, 0x0000,  0xFFD0, 0x0000,  0x3340, 0x0000,  0x3300, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x1D00, 0x0000,  0xFF40, 0x0000,  0xCC00, 0x0000,  0xFC00, 0x0000,  0x7F00, 0x0000,  0x0FC0, 0x0000,  0x0DC0, 0x0000,  0x4FC0, 0x0000,  0xFF00, 0x0000,  0x0800, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x2410, 0x0000,  0xEE70, 0x0000,  0xC3D0, 0x0000,  0xDBC0, 0x0000,  0x3E80, 0x0000,  0x03FD, 0x0000,  0x07C3, 0x0000,  0x0DC3, 0x0000,  0x0C7D, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0900, 0x0000,  0x3F40, 0x0000,  0x3380, 0x0000,  0x2F00, 0x0000,  0x3F00, 0x0000,  0xE39C, 0x0000,  0xC0F4, 0x0000,  0xD0F4, 0x0000,  0x7FDC, 0x0000,  0x0500, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  3, 0x1000, 0x0000,  0xF000, 0x0000,  0xC000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  3, 0x1000, 0x0000,  0x3000, 0x0000,  0xE000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xD000, 0x0000,  0x7000, 0x0000,  0x3400, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  3, 0x4000, 0x0000,  0xD000, 0x0000,  0x7000, 0x0000,  0x3000, 0x0000,  0x3400, 0x0000,  0x3400, 0x0000,  0x3400, 0x0000,  0x3000, 0x0000,  0xF000, 0x0000,  0xC000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0100, 0x0000,  0x1340, 0x0000,  0x1F80, 0x0000,  0x2FC0, 0x0000,  0x0300, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0700, 0x0000,  0x0700, 0x0000,  0xBFF0, 0x0000,  0xBFF0, 0x0000,  0x0700, 0x0000,  0x0700, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  3, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x1000, 0x0000,  0xB000, 0x0000,  0xD000, 0x0000,  0x8000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xFC00, 0x0000,  0x5400, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  3, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xC000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0040, 0x0000,  0x00C0, 0x0000,  0x01C0, 0x0000,  0x0340, 0x0000,  0x0300, 0x0000,  0x0B00, 0x0000,  0x0C00, 0x0000,  0x1C00, 0x0000,  0x3800, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0D00, 0x0000,  0x7FC0, 0x0000,  0xF0C0, 0x0000,  0xC0D0, 0x0000,  0xC0F0, 0x0000,  0xC0E0, 0x0000,  0xD0D0, 0x0000,  0xF1C0, 0x0000,  0x3F40, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0xFC00, 0x0000,  0x3C00, 0x0000,  0x3C00, 0x0000,  0x3C00, 0x0000,  0x3C00, 0x0000,  0x3C00, 0x0000,  0x3C00, 0x0000,  0x3C00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x1900, 0x0000,  0xFF40, 0x0000,  0xC2C0, 0x0000,  0x43C0, 0x0000,  0x0300, 0x0000,  0x0E00, 0x0000,  0x3C00, 0x0000,  0x7000, 0x0000,  0xFFC0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x2800, 0x0000,  0xFF00, 0x0000,  0xC340, 0x0000,  0x0340, 0x0000,  0x3F00, 0x0000,  0x0740, 0x0000,  0x02C0, 0x0000,  0xC3C0, 0x0000,  0xFF00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x07C0, 0x0000,  0x0FC0, 0x0000,  0x2DC0, 0x0000,  0x31C0, 0x0000,  0xE1C0, 0x0000,  0xFFE0, 0x0000,  0x01C0, 0x0000,  0x01C0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0500, 0x0000,  0x3FC0, 0x0000,  0x3000, 0x0000,  0x7400, 0x0000,  0x7F40, 0x0000,  0x01C0, 0x0000,  0x00C0, 0x0000,  0xC2C0, 0x0000,  0xFF00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0F00, 0x0000,  0x3C00, 0x0000,  0x7500, 0x0000,  0xFF80, 0x0000,  0xD0C0, 0x0000,  0xC0C0, 0x0000,  0xD1C0, 0x0000,  0x7F40, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x5540, 0x0000,  0xFFC0, 0x0000,  0x03C0, 0x0000,  0x0300, 0x0000,  0x0B00, 0x0000,  0x0D00, 0x0000,  0x1C00, 0x0000,  0x3800, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x1900, 0x0000,  0xBF40, 0x0000,  0xD3C0, 0x0000,  0xF380, 0x0000,  0x3F00, 0x0000,  0xE3C0, 0x0000,  0xC0C0, 0x0000,  0xD2C0, 0x0000,  0x7F40, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x1D00, 0x0000,  0xBF80, 0x0000,  0xC0C0, 0x0000,  0xC0C0, 0x0000,  0xD0C0, 0x0000,  0x7FC0, 0x0000,  0x0380, 0x0000,  0x0B00, 0x0000,  0x2C00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  2, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xC000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xC000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  3, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x7000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x1000, 0x0000,  0xB000, 0x0000,  0xD000, 0x0000,  0x8000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x00B4, 0x0000,  0x0FC0, 0x0000,  0xFC00, 0x0000,  0xBC00, 0x0000,  0x0BC0, 0x0000,  0x00B4, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xFFF4, 0x0000,  0x0000, 0x0000,  0xBFF0, 0x0000,  0x5550, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xF400, 0x0000,  0x1F40, 0x0000,  0x01F4, 0x0000,  0x01F0, 0x0000,  0x1F40, 0x0000,  0xF400, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  5, 0x0400, 0x0000,  0x7F00, 0x0000,  0xD340, 0x0000,  0x0300, 0x0000,  0x0B00, 0x0000,  0x1C00, 0x0000,  0x3400, 0x0000,  0x0000, 0x0000,  0x3400, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 10, 0x07E0, 0x0000,  0x2E7C, 0x0000,  0x7157, 0x0000,  0xEBF3, 0x0000,  0xCC33, 0x0000,  0xCD33, 0x0000,  0xE7FE, 0x0000,  0x7406, 0x0000,  0x1FFC, 0x0000,  0x0040, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0F00, 0x0000,  0x0F40, 0x0000,  0x1EC0, 0x0000,  0x34C0, 0x0000,  0x30E0, 0x0000,  0xBFF0, 0x0000,  0xE570, 0x0000,  0xC038, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x5400, 0x0000,  0xFF80, 0x0000,  0xC0C0, 0x0000,  0xC1C0, 0x0000,  0xFF40, 0x0000,  0xC1D0, 0x0000,  0xC0F0, 0x0000,  0xC0E0, 0x0000,  0xFFC0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0780, 0x0000,  0x3FF4, 0x0000,  0xB010, 0x0000,  0xD000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xD000, 0x0000,  0x7424, 0x0000,  0x2FF0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x5400, 0x0000,  0xFFC0, 0x0000,  0xC0E0, 0x0000,  0xC030, 0x0000,  0xC030, 0x0000,  0xC030, 0x0000,  0xC070, 0x0000,  0xC0D0, 0x0000,  0xFF80, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  5, 0x5500, 0x0000,  0xFF40, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xFE00, 0x0000,  0xD500, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xFF40, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  5, 0x5500, 0x0000,  0xFF00, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xFD00, 0x0000,  0xFC00, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0B80, 0x0000,  0x3FF4, 0x0000,  0xF010, 0x0000,  0xC000, 0x0000,  0xC3FC, 0x0000,  0xC05C, 0x0000,  0xD01C, 0x0000,  0x7034, 0x0000,  0x2FE0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0xC034, 0x0000,  0xC034, 0x0000,  0xC034, 0x0000,  0xFFF4, 0x0000,  0xD574, 0x0000,  0xC034, 0x0000,  0xC034, 0x0000,  0xC034, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  2, 0x0000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  5, 0x0000, 0x0000,  0x0700, 0x0000,  0x0700, 0x0000,  0x0700, 0x0000,  0x0700, 0x0000,  0x0700, 0x0000,  0x0700, 0x0000,  0x0B00, 0x0000,  0xFD00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0xC0D0, 0x0000,  0xC380, 0x0000,  0xCE00, 0x0000,  0xFD00, 0x0000,  0xF700, 0x0000,  0xC380, 0x0000,  0xC0C0, 0x0000,  0xC0B0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xFFC0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 10, 0x0000, 0x0000,  0x3C0F, 0x0000,  0x3C0F, 0x0000,  0x7D2F, 0x0000,  0xBB37, 0x4000,  0xD333, 0x4000,  0xD3B3, 0xC000,  0xC2D1, 0xC000,  0xC1C1, 0xC000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0xD030, 0x0000,  0xF030, 0x0000,  0xFC30, 0x0000,  0xCD30, 0x0000,  0xC730, 0x0000,  0xC2F0, 0x0000,  0xC0F0, 0x0000,  0xC030, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0640, 0x0000,  0x3FF0, 0x0000,  0xB03C, 0x0000,  0xC00C, 0x0000,  0xC00C, 0x0000,  0xC00C, 0x0000,  0xD01C, 0x0000,  0x7034, 0x0000,  0x2FE0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x5400, 0x0000,  0xFFC0, 0x0000,  0xC0D0, 0x0000,  0xC0F0, 0x0000,  0xC1D0, 0x0000,  0xFF40, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0640, 0x0000,  0x3FF0, 0x0000,  0xB03C, 0x0000,  0xC00C, 0x0000,  0xC00C, 0x0000,  0xC00C, 0x0000,  0xD07C, 0x0000,  0x703C, 0x0000,  0x2FED, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x5400, 0x0000,  0xFFC0, 0x0000,  0xC0B0, 0x0000,  0xC070, 0x0000,  0xFFD0, 0x0000,  0xFF40, 0x0000,  0xC2C0, 0x0000,  0xC0D0, 0x0000,  0xC070, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x1500, 0x0000,  0xBFC0, 0x0000,  0xC000, 0x0000,  0xD000, 0x0000,  0x7D00, 0x0000,  0x0B80, 0x0000,  0x01C0, 0x0000,  0x41C0, 0x0000,  0xFF40, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x5540, 0x0000,  0xFFC0, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0xC034, 0x0000,  0xC034, 0x0000,  0xC034, 0x0000,  0xC034, 0x0000,  0xC034, 0x0000,  0xC034, 0x0000,  0xF070, 0x0000,  0x3FD0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0xC034, 0x0000,  0xE070, 0x0000,  0x70F0, 0x0000,  0x30D0, 0x0000,  0x39C0, 0x0000,  0x1F80, 0x0000,  0x0F00, 0x0000,  0x0B00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 10, 0x0000, 0x0000,  0xC1C1, 0xC000,  0xC3E1, 0xC000,  0xD373, 0xC000,  0xF333, 0x4000,  0x7B37, 0x0000,  0x3D2F, 0x0000,  0x3C1F, 0x0000,  0x3C0F, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0xF0F0, 0x0000,  0x35C0, 0x0000,  0x1F40, 0x0000,  0x0F00, 0x0000,  0x1F40, 0x0000,  0x35C0, 0x0000,  0xB0B0, 0x0000,  0xC034, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0xC0D0, 0x0000,  0xB2C0, 0x0000,  0x3700, 0x0000,  0x1E00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x5540, 0x0000,  0xFFE0, 0x0000,  0x01C0, 0x0000,  0x0340, 0x0000,  0x0F00, 0x0000,  0x1C00, 0x0000,  0x3400, 0x0000,  0xF000, 0x0000,  0xFFF0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  3, 0x5000, 0x0000,  0xD000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xE000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  5, 0x4000, 0x0000,  0xC000, 0x0000,  0xE000, 0x0000,  0x3000, 0x0000,  0x3400, 0x0000,  0x1C00, 0x0000,  0x0C00, 0x0000,  0x0E00, 0x0000,  0x0300, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  3, 0x5000, 0x0000,  0xF000, 0x0000,  0x7000, 0x0000,  0x7000, 0x0000,  0x7000, 0x0000,  0x7000, 0x0000,  0x7000, 0x0000,  0x7000, 0x0000,  0x7000, 0x0000,  0xE000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0100, 0x0000,  0x0B00, 0x0000,  0x0FC0, 0x0000,  0x3CD0, 0x0000,  0x7070, 0x0000,  0xD034, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x5550, 0x0000,  0xFFE0, 0x0000,  0x0000, 0x0000,},
    {  3, 0x1000, 0x0000,  0xF000, 0x0000,  0xC000, 0x0000,  0x4000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x1500, 0x0000,  0xBF80, 0x0000,  0x00C0, 0x0000,  0x3FC0, 0x0000,  0xD3C0, 0x0000,  0xC1C0, 0x0000,  0xBFC0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x8000, 0x0000,  0xC000, 0x0000,  0xC500, 0x0000,  0xFF80, 0x0000,  0xD0C0, 0x0000,  0xC0D0, 0x0000,  0xC0D0, 0x0000,  0xD0C0, 0x0000,  0xFF40, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0100, 0x0000,  0x3F80, 0x0000,  0xE000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xF000, 0x0000,  0x3FC0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0080, 0x0000,  0x00D0, 0x0000,  0x04D0, 0x0000,  0x7FD0, 0x0000,  0xD0D0, 0x0000,  0xC0D0, 0x0000,  0xC0D0, 0x0000,  0xD1D0, 0x0000,  0x7FD0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0500, 0x0000,  0x7FC0, 0x0000,  0xD0C0, 0x0000,  0xFFD0, 0x0000,  0xD540, 0x0000,  0xE040, 0x0000,  0x3FC0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0400, 0x0000,  0x3C00, 0x0000,  0x3000, 0x0000,  0xFC00, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0540, 0x0000,  0x7FD0, 0x0000,  0xD0D0, 0x0000,  0xC0D0, 0x0000,  0xC0D0, 0x0000,  0xD0D0, 0x0000,  0x3FD0, 0x0000,  0x00C0, 0x0000,  0xBBC0, 0x0000,  0x2D00, 0x0000,},
    {  6, 0x8000, 0x0000,  0xC000, 0x0000,  0xC400, 0x0000,  0xFF40, 0x0000,  0xC2C0, 0x0000,  0xC1C0, 0x0000,  0xC1C0, 0x0000,  0xC1C0, 0x0000,  0xC1C0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  3, 0xC000, 0x0000,  0x8000, 0x0000,  0x4000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  2, 0xC000, 0x0000,  0x8000, 0x0000,  0x4000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0x4000, 0x0000,},
    {  6, 0x8000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC3C0, 0x0000,  0xCF00, 0x0000,  0xFC00, 0x0000,  0xEF00, 0x0000,  0xC340, 0x0000,  0xC1C0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  2, 0x8000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x0414, 0x0000,  0xFFFF, 0x0000,  0xC3C3, 0x0000,  0xC3C3, 0x0000,  0xC3C3, 0x0000,  0xC3C3, 0x0000,  0xC2C3, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0400, 0x0000,  0xFF40, 0x0000,  0xC2C0, 0x0000,  0xC1C0, 0x0000,  0xC1C0, 0x0000,  0xC1C0, 0x0000,  0xC1C0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0500, 0x0000,  0x7F80, 0x0000,  0xD0C0, 0x0000,  0xC0D0, 0x0000,  0xC0D0, 0x0000,  0xE0C0, 0x0000,  0x3F80, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x4500, 0x0000,  0xFF80, 0x0000,  0xD0C0, 0x0000,  0xC0D0, 0x0000,  0xC0D0, 0x0000,  0xD0C0, 0x0000,  0xFF40, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0x8000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0440, 0x0000,  0x7FD0, 0x0000,  0xD0D0, 0x0000,  0xC0D0, 0x0000,  0xC0D0, 0x0000,  0xD1D0, 0x0000,  0x7FD0, 0x0000,  0x00D0, 0x0000,  0x00D0, 0x0000,  0x0080, 0x0000,},
    {  5, 0x0000, 0x0000,  0x0000, 0x0000,  0x0400, 0x0000,  0xFE00, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x1500, 0x0000,  0xBF40, 0x0000,  0xC000, 0x0000,  0x7D00, 0x0000,  0x0B40, 0x0000,  0x43C0, 0x0000,  0xFF00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x1000, 0x0000,  0x7000, 0x0000,  0xFC00, 0x0000,  0x7000, 0x0000,  0x7000, 0x0000,  0x7000, 0x0000,  0x7000, 0x0000,  0x3C00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0040, 0x0000,  0xC0C0, 0x0000,  0xC0C0, 0x0000,  0xC0C0, 0x0000,  0xC1C0, 0x0000,  0xC3C0, 0x0000,  0xBFC0, 0x0000,  0x0400, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xC2C0, 0x0000,  0xD340, 0x0000,  0xB300, 0x0000,  0x3B00, 0x0000,  0x3D00, 0x0000,  0x1C00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 10, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xC2C3, 0x4000,  0xE3D3, 0x0000,  0xB3B7, 0x0000,  0x3B3E, 0x0000,  0x3D3C, 0x0000,  0x1C2C, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xF3C0, 0x0000,  0x3700, 0x0000,  0x1D00, 0x0000,  0x3F00, 0x0000,  0xB380, 0x0000,  0xC0C0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xC1C0, 0x0000,  0xD380, 0x0000,  0xB300, 0x0000,  0x3B00, 0x0000,  0x3D00, 0x0000,  0x2C00, 0x0000,  0x2C00, 0x0000,  0x3400, 0x0000,  0x2000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xFF40, 0x0000,  0x0700, 0x0000,  0x0C00, 0x0000,  0x3400, 0x0000,  0xB000, 0x0000,  0xFF80, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0400, 0x0000,  0x3800, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x7000, 0x0000,  0xE000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x2C00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  2, 0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0xC000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x4000, 0x0000,  0xB000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3400, 0x0000,  0x2C00, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0xD000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xBC90, 0x0000,  0xDFC0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,}
};

const font_t bpreplay8 = {BPREPLAY8_BITS_PER_PIXEL, BPREPLAY8_WORDS_PER_LINE, BPREPLAY8_HEIGHT, BPREPLAY8_HEIGHT - (BPREPLAY8_HEIGHT >> 2), BPREPLAY8_FIRST_CHAR, BPREPLAY8_CHARS, BPREPLAY8_SPACE, bpreplay8_data[0] };

